
// Atari Interlaced Studio

.enum	__ftype
mic, inp, ist, raw, mcp, hip, cin
.ende

ftype	= __ftype(INP)

buf0	= $2010
buf1	= $4010

colpm0	= $d012
colpm1	= $d013
colpm2	= $d014
colpm3	= $d015

color0	= $d016
color1	= $d017
color2	= $d018
color3	= $d019
colbak	= $d01a
gtictl	= $d01b

skctl	= $d20f

portb	= $d301

dmactl	= $d400
dlptr	= $d402
wsync	= $d40a
vcount	= $d40b
nmien	= $d40e
nmist	= $d40f

/*-------------------------------------------------------------------------------------------------*/

	org $80

regA	.ds 1
regX	.ds 1
regY	.ds 1
cnt	.ds 1

/*-------------------------------------------------------------------------------------------------*/

	.get 'C:\Documents and Settings\Matej\Desktop\Tinctu - Forever C\Picture\Final\tin-survivors.dat',16000,9		; palette

/*-------------------------------------------------------------------------------------------------*/

	org buf0
	ins 'C:\Documents and Settings\Matej\Desktop\Tinctu - Forever C\Picture\Final\tin-survivors.dat',0,8000

	ift ftype<>0
	org buf1
	ins 'C:\Documents and Settings\Matej\Desktop\Tinctu - Forever C\Picture\Final\tin-survivors.dat',8000,8000
	eif

/*-------------------------------------------------------------------------------------------------*/

	.align	$100

	ift	ftype=0			; MIC

	dlist0:	dta d'ppp'
		dta $4e,a(buf0)
		:101 dta $e
		dta $4e,0,h(buf0+$1000)
		:89 dta $e
		dta $41,a(dlist0)

	eli	ftype=5			; HIP

	dlist0:	dta d'pp',$30+$80
		dta $4f,a(buf0)
		:101 dta $f
		dta $4f,0,h(buf0+$1000)
		:97 dta $f
		dta $41,a(dlist1)

	dlist1:	dta d'pp',$30+$80
		dta $4f,a(buf1)
		:101 dta $f
		dta $4f,0,h(buf1+$1000)
		:97 dta $f
		dta $41,a(dlist0)

	eli	ftype=6			; CIN

	dlist0:	dta d'pp',$70+$80
		dta $4e,a(buf0)
		:50 dta $f,$e
		dta $f
		dta $4e,0,h(buf0+$1000)
		:44 dta $f,$e
		dta $f
		dta $41,a(dlist1)

	dlist1:	dta d'pp',$70+$80
		dta $4f,a(buf1)
		:50 dta $e,$f
		dta $e
		dta $4f,0,h(buf1+$1000)
		:44 dta $e,$f
		dta $e
		dta $41,a(dlist0)

	els				; INP, IST, RAW, MCP

	dlist0:	dta d'pp',$30+$80
		dta $4e,a(buf0)
		:101 dta $e
		dta $4e,0,h(buf0+$1000)
		:96 dta $e
		dta $e
		dta $41,a(dlist1)

	dlist1:	dta d'pp',$30+$80
		dta $4e,a(buf1)
		:101 dta $e
		dta $4e,0,h(buf1+$1000)
		:96 dta $e
		dta $e
		dta $41,a(dlist0)

	eif

/*-------------------------------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------------------------------*/

main	lda:cmp:req 20

	sei
	mva	#$00	nmien
	mva	#$fe	portb

	mwa	#dlist0	dlptr
	mwa	#dli0	vdli

	ift	ftype=6
	mva	#$c0	mode+1
	eif

	mwa	#NMI	$fffa

	mva	#$c0	nmien


	lda:rne vcount

wait	lda skctl			; press any key
	and #4
	bne wait

	lda:rne vcount

	mva	#$ff	portb
	mva	#$40	nmien
	cli

	mva #$ff 764			; clear info about pressed key
	rts				; exit

/*-------------------------------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------------------------------*/

	ift (ftype=0)||(ftype=1)||(ftype=2)	; MIC, INP, IST

	dli0:	rti	

	eli (ftype=3)||(ftype=4)		; RAW, MCP

	dli0:	sta regA
		stx regX
		sty regY

		mva #99 cnt

	loop0:	lda #.get[1]
		ldx #.get[2]
		ldy #.get[3]
		sta wsync
		sta color0
		stx color1
		sty color2

		lda #.get[5]
		ldx #.get[6]
		ldy #.get[7]
		sta wsync
		sta color0
		stx color1
		sty color2

		dec cnt
		bpl loop0

		mwa #dli1 vdli

		lda regA
		ldx regX
		ldy regY
		rti

	dli1:	sta regA
		stx regX
		sty regY

		mva #99 cnt

	loop1:	lda #.get[5]
		ldx #.get[6]
		ldy #.get[7]
		sta wsync
		sta color0
		stx color1
		sty color2

		lda #.get[1]
		ldx #.get[2]
		ldy #.get[3]
		sta wsync
		sta color0
		stx color1
		sty color2

		dec cnt
		bpl loop1

		mwa #dli0 vdli

		lda regA
		ldx regX
		ldy regY
		rti

	eli ftype=5				; HIP

	dli0:	sta regA
		stx regX

		ldx #100
	loop0:	lda #$40
		sta wsync
		sta gtictl
		lda #0
		sta colbak
		lda #$80
		sta wsync
		sta gtictl
		lda #.get[8]
		sta colbak
		dex
		bne loop0

		mwa #dli1 vdli

		lda regA
		ldx regX
		rti

	dli1:	sta regA
		stx regX

		ldx #100
	loop1:	lda #$80
		sta wsync
		sta gtictl
		lda #.get[8]
		sta colbak
		lda #$40
		sta wsync
		sta gtictl
		lda #0
		sta colbak
		dex
		bne loop1

		mwa #dli0 vdli

		lda regA
		ldx regX
		rti
	els					; CIN

	dli0:	sta regA
		stx regX

		ldx #192
	mode:	lda #$c0

	loop:	eor #$c0
		sta wsync
		sta gtictl
		dex
		bne loop

		eor #$c0
		sta mode+1

		lda regA
		ldx regX
		rti

	eif

/*-------------------------------------------------------------------------------------------------*/

NMI	bit nmist
	bpl vbl

	jmp dli0
vdli	equ *-2

vbl	sta nmist
	phr

	mva #$22	dmactl

	ift ftype=5
	
	mva #.get[0]	colpm0
	mva #.get[1]	colpm1
	mva #.get[2]	colpm2
	mva #.get[3]	colpm3
	mva #.get[4]	color0
	mva #.get[5]	color1
	mva #.get[6]	color2
	mva #.get[7]	color3

	els

	mva #.get[0]	colbak
	mva #.get[1]	color0
	mva #.get[2]	color1
	mva #.get[3]	color2	

	eif

	plr
	rti

/*-------------------------------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------------------------------*/

	run main
